package com.qboxus.tictic.adapters

import android.graphics.Typeface
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.core.content.ContextCompat
import androidx.databinding.DataBindingUtil
import androidx.recyclerview.widget.RecyclerView
import com.qboxus.tictic.R
import com.qboxus.tictic.databinding.ItemInboxListBinding
import com.qboxus.tictic.interfaces.ChatAdapterClickListener
import com.qboxus.tictic.models.InboxModel
import com.qboxus.tictic.simpleclasses.DateOprations
import com.qboxus.tictic.simpleclasses.DebounceClickHandler
import com.qboxus.tictic.simpleclasses.Functions.frescoImageLoad

/**
 * Created by qboxus on 3/20/2018.
 */
class InboxAdapter(
    val datalist: ArrayList<InboxModel>,
    val listener: ChatAdapterClickListener
) : RecyclerView.Adapter<InboxAdapter.CustomViewHolder>() {


    override fun onCreateViewHolder(viewGroup: ViewGroup, viewtype: Int): CustomViewHolder {
        val binding:ItemInboxListBinding =DataBindingUtil.inflate(LayoutInflater.from(viewGroup.context),
            R.layout.item_inbox_list, viewGroup, false)
        return CustomViewHolder(binding)
    }

    override fun getItemCount(): Int {
        return datalist.size
    }

    override fun onBindViewHolder(holder: CustomViewHolder, position: Int) {
        val item = datalist.get(position)

        holder.binding.username.text = "${item.name}"

        item.date?.let {
            val date = DateOprations.changeDateTodayYesterday(holder.itemView.context, item.date)
            holder.binding.datetxt.text = "• $date"
        }


        holder.binding.userImage.controller = frescoImageLoad(
            "${item.pic}", R.drawable.ic_user_icon, holder.binding.userImage, false)
        val status = item.status
        if (status == "0") {
            holder.binding.newMsgDot.visibility = View.VISIBLE
            holder.binding.message.text = "1 new message "
            holder.binding.message.setTypeface(null, Typeface.BOLD)
            holder.binding.message.setTextColor(
                ContextCompat.getColor(
                    holder.itemView.context,
                    R.color.black
                )
            )
        } else {
            holder.binding.newMsgDot.visibility = View.GONE
            holder.binding.message.text = item.msg
            holder.binding.message.setTypeface(null, Typeface.NORMAL)
            holder.binding.message.setTextColor(
                ContextCompat.getColor(
                    holder.itemView.context,
                    R.color.darkgray
                )
            )
        }
        holder.bind(position, listener)
    }

    fun filter(updatedList: ArrayList<InboxModel>) {
        datalist.clear()
        datalist.addAll(updatedList)
        notifyDataSetChanged()
    }


    inner class CustomViewHolder(val binding:ItemInboxListBinding) : RecyclerView.ViewHolder(
        binding.root) {


        fun bind(position: Int,listener: ChatAdapterClickListener) {
            binding.mainlayout.setOnClickListener(DebounceClickHandler{
                listener.onItemClick(it,position)
            })
            binding.mainlayout.setOnLongClickListener{
                listener.onItemLongClick(it,position)
                true
            }
        }
    }
}